;;;
;;;    VPSCALE.LSP
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;    find the scale of a viewport relative to paper space
;    Carl Bethea  11 April 91
;
;     Paul Vine   20 April 1999   Ported to 2000.
;
;--- paper -------------------------------------------------
; returns T if in paper space
(defun paper ()
   (> 2 (getvar "cvport")(getvar "tilemode")) ; port=1 & tile=0
)
;
;--- getx --------------------------------------------------
; return <nth> dotted pair of the extended entity data
; from an entity association list <data>
;
(defun getx (n data)
(nth n (cdadr (assoc -3 data)))
)
;
;
;
;--- c:vpscale ----------------------------------------------
; get the xp scale factor of a pspace viewport
;
(defun c:vpscale (/ ent data cvsize cvhgt units vpna flag)
 (cond
  ((not (equal 0 (getvar "tilemode")))
   (princ "\n  Command not allowed unless TILEMODE is set to 0  ") 
  )
  ((and (/= 1 (getvar "cvport"))
        (setq vpna (acet-currentviewport-ename))
        (equal 1 (logand 1 (cdr (assoc 90 (entget vpna)))))
   )
   (princ "\n  Command not allowed in perspective view  ") 
  )
  (T
 
      (acet-error-init
        (list
          (list "cmdecho" 0
                "luprec" (getvar "luprec")
                "dimzin" 8
          )
          T     ;flag. True means use undo for error clean up.
 
        );list
      );acet-error-init
 
 
      (if (paper)
        ;(setq ent (car (entsel "\nSelect edge of viewport: ")))
 
       ;;Added the following code to replace the above line.  Irregularly shaped floating viewports actuall
       ;;consist fo two entities (a pline and a viewport) with reactors on each other to point to each other
       ;;so a simple (entsel) returned a pline instead of a viewport. Had to uise the built-in filtering
       ;;capability of 'acet-ui-single-select' to get around this problem.
       (progn
          (while (not flag)
           (princ "\nSelect edge of viewport.")
           (setq ent (acet-ui-single-select '((0 . "viewport")) T )) ;setq
           (if (and ent
                    (= 1 (logand 1 (cdr (assoc 90 (entget ent)))))
               )
               (progn
                 (princ "\nViewports with perspective view on are not allowed.")
                 (setq flag nil)
               );progn
               (setq flag T)
           );if
          );while
        );progn
        (setq ent (acet-currentviewport-ename))
      )
      (cond
        ((and
            ent
            (setq data (entget ent '("ACAD")))
            (= "VIEWPORT" (acet-dxf 0 DATA))
         );and
          (setq cvhgt  (acet-dxf 41 DATA)  ; viewport height
                cvsize (cdr (getx 6 data))    ; viewsize from extended data
          )
          (prompt "\nPS:MS == ")
          (cond
            ((< cvsize cvhgt)
              (princ (rtos (/ cvhgt cvsize) 2))
              (princ ":1")
            )
            (T (princ "1:")
              (princ (rtos (/ cvsize cvhgt) 2))
            )
          );cond
          (setq units (getvar "lunits"))
          (setvar "luprec" 8)
          (cond
            ((= units 4)
              (prompt (strcat "\nViewport Scale: " (rtos (/ 12 (/ cvsize cvhgt))) " = 1'-0\""))
            )
            ((= units 3)
              (prompt (strcat "\nViewport Scale: 1\" = " (rtos (/ cvsize cvhgt))))
            )
          )
        )
        (T (prompt " no viewport found."))
      );cond
      (acet-error-restore)                                  ; Retsore values
  )
 );cond close 
  (princ)
);c:vpscale


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; aAcAADCCB2QGCSqGSIb3DQEHAqCCB1UwggdRAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICIjCCAh4CAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEAVtGVdML9col/pYWsLaLp/ksWejZsoLpIDsL0zN1Ie+FlOxqt0sHh
;;; kEkQB/2FdTd6V/YWRidzvihgLB20uU+IonBNsAkNz3WNHZ/aeTmduQumFnMeUyfO
;;; fVtBQmlYcNfD/8ssdGysj7mSqPCoDhLMcT8RCyJVMpaMfxUFOMfrdiPIT+fs07V0
;;; zexR/pJV4IIc3QfvrI7Bu7jZr4pggk1WfbuDCvJNM36kF3bveVK0yRm7bg3mgQ7l
;;; WSRU8jkLGTlqbTNjYizk/UTKff0A7F7xrG8qq/VZ7lBJeou+SHqZx+RM7cdvQtBA
;;; o1rBB2GT12dwze6aNLY63X9Zds9o5qDmCaFhMF8GA1UdDjFYBFYzADkAOwAyAC8A
;;; NwAvADIAMAAxADYALwA1AC8AOQAvADUAOQAvAFQAaQBtAGUAIABmAHIAbwBtACAA
;;; dABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----